/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.api.WSMember;
import filenet.ws.api.WSParam;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class WSTemplateBase {
    public static final String DefaultEncoding = "UTF-8";
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static final String m_className = "WSTemplateBase";
    static final int TEMPLATE_NO_BINDING = 0;
    static final int TEMPLATE_SOAP_DOCUMENT_BINDING = 1;
    public static final int TEMPLATE_SOAP_RPC_BINDING = 2;
    protected WSMember[] m_members = null;
    private static String s_leadingTypeNameCode = "###";
    private static String s_trailingTypeNameCode = "~~~$]]";

    public static String _get_FILE_DATE() {
        return "$Date:   11 Sep 2008 10:26:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.26  $";
    }

    protected abstract String getTemplateNamespace();

    protected abstract String getTemplateRootName();

    protected abstract void initMembers();

    void releaseReferences() {
        block4: {
            try {
                if (this.m_members != null) {
                    WSMember[] members = this.m_members;
                    this.m_members = null;
                    WSMember member = null;
                    for (int i = 0; i < members.length; ++i) {
                        if (members[i] == null) continue;
                        member = members[i];
                        members[i] = null;
                        member.releaseReferences();
                    }
                    members = null;
                    Object var2_3 = null;
                }
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block4;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public static String elementToString(Element element) throws IOException {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (Exception ex) {
            doc = new DocumentImpl();
        }
        Element root = doc.createElement("temproot");
        doc.appendChild(root);
        root.appendChild(doc.importNode(element, true));
        return WSTemplateBase.elementToString(doc);
    }

    public static String elementToString(Document doc) throws IOException {
        String method = "elementToString(Document doc)";
        if (doc != null) {
            OutputFormat format = new OutputFormat(doc);
            String encoding = null;
            encoding = doc != null && doc instanceof DeferredDocumentImpl ? ((DeferredDocumentImpl)doc).getXmlEncoding() : DefaultEncoding;
            format.setEncoding(encoding);
            format.setIndenting(true);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
            try {
                serial.asDOMSerializer();
                Node child = doc.getDocumentElement().getFirstChild();
                while (!(child instanceof Element) && (child = child.getNextSibling()) != null) {
                }
                if (child != null && child instanceof Element) {
                    serial.serialize((Element)child);
                    StringBuffer buf = stringOut.getBuffer();
                    buf.delete(0, buf.length() - 1);
                    while (child != null && child instanceof Element) {
                        Element elt = (Element)child;
                        serial.serialize(elt);
                        child = elt.getNextSibling();
                    }
                }
            }
            catch (IOException ex) {
                logger.throwing(m_className, method, ex);
                throw ex;
            }
            StringBuffer sBuffer = stringOut.getBuffer();
            int blockSize = 100000;
            String s = new String();
            while (sBuffer.length() > blockSize) {
                s = s + sBuffer.substring(0, blockSize);
                sBuffer.delete(0, blockSize);
            }
            s = s + sBuffer.toString();
            sBuffer.delete(0, sBuffer.length() - 1);
            String results = new String();
            int startIndex = 0;
            int endIndex = 0;
            while ((endIndex = s.indexOf("<?xml", startIndex)) != -1) {
                if (endIndex > startIndex) {
                    results = results + s.substring(startIndex, endIndex);
                }
                if ((startIndex = s.indexOf("?>", endIndex)) == -1) continue;
                startIndex += 2;
            }
            results = results + s.substring(startIndex);
            results = results.trim();
            return results;
        }
        return new String();
    }

    public static String expressionToXML(String expression) {
        String method = "expressionToXML(String expression)";
        if (expression != null) {
            int i;
            boolean bReplace;
            char c;
            int fromIndex;
            BufferedReader reader = new BufferedReader(new StringReader(expression));
            String line = null;
            String xml = new String();
            try {
                while ((line = reader.readLine()) != null) {
                    int index1;
                    fromIndex = 0;
                    int index0 = index1 = line.indexOf("\"<", fromIndex);
                    c = '\u0000';
                    bReplace = true;
                    while (index1 != -1) {
                        index0 = index1;
                        bReplace = true;
                        for (i = index1 - 1; i >= 0; --i) {
                            c = line.charAt(i);
                            if (Character.isWhitespace(c)) continue;
                            if (c == '+') {
                                index0 = i;
                                break;
                            }
                            bReplace = false;
                            break;
                        }
                        xml = bReplace ? xml + line.substring(fromIndex, index0) + "<" : xml + line.substring(fromIndex, index0 + 2);
                        fromIndex = index1 + 2;
                        index1 = line.indexOf("\"<", fromIndex);
                    }
                    xml = xml + line.substring(fromIndex) + "\n";
                }
            }
            catch (Exception ex) {
                logger.throwing(m_className, method, ex);
                return null;
            }
            try {
                expression = xml;
                xml = new String();
                reader = new BufferedReader(new StringReader(expression));
                while ((line = reader.readLine()) != null) {
                    int index0;
                    fromIndex = 0;
                    int index1 = index0 = line.indexOf(">\"", fromIndex);
                    c = '\u0000';
                    bReplace = true;
                    while (index0 != -1) {
                        index1 = index0 + 2;
                        bReplace = true;
                        for (i = index0 + 2; i < line.length(); ++i) {
                            c = line.charAt(i);
                            if (Character.isWhitespace(c)) continue;
                            index1 = i;
                            if (c == '+') {
                                ++index1;
                                break;
                            }
                            bReplace = false;
                            break;
                        }
                        xml = bReplace ? xml + line.substring(fromIndex, index0) + ">" : xml + line.substring(fromIndex, index0 + 2);
                        fromIndex = index1;
                        index0 = line.indexOf(">\"", fromIndex);
                    }
                    xml = xml + line.substring(fromIndex) + "\n";
                }
            }
            catch (Exception ex) {
                logger.throwing(m_className, method, ex);
                return null;
            }
            xml = WSTemplateBase.replaceAll(xml, "\"\"", "\"");
            return xml;
        }
        return null;
    }

    public static Document xmlToDocument(String xml) {
        String method = "xmlToDocument(Strng xml)";
        if (xml == null) {
            return null;
        }
        try {
            String s = null;
            int idx = xml.indexOf("<?xml");
            if (idx != -1) {
                s = xml;
            } else {
                String rootElementName = "tempRoot";
                if (xml.indexOf("<" + rootElementName + ">") == -1) {
                    s = "<" + rootElementName + ">" + WSTemplateBase.replaceAll(xml, "\n", "") + "</" + rootElementName + ">";
                }
            }
            Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(s)), null, null, false, false);
            return doc;
        }
        catch (Throwable t) {
            logger.throwing(m_className, method, t);
            return null;
        }
    }

    public static String docToString(Document doc) throws IOException {
        String method = "docToString(Document doc)";
        if (doc != null) {
            OutputFormat format = new OutputFormat(doc);
            String encoding = null;
            encoding = doc != null && doc instanceof DeferredDocumentImpl ? ((DeferredDocumentImpl)doc).getXmlEncoding() : DefaultEncoding;
            format.setEncoding(encoding);
            format.setIndenting(true);
            StringWriter stringOut = new StringWriter();
            XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
            try {
                serial.asDOMSerializer();
                serial.serialize(doc);
            }
            catch (IOException ex) {
                logger.throwing(m_className, method, ex);
                throw ex;
            }
            String result = stringOut.toString();
            result = result.trim();
            return result;
        }
        return new String();
    }

    static String replaceAll(String s, String reges, String replacement) {
        if (s == null) {
            return null;
        }
        Vector<StringBuffer> returnStrings = new Vector<StringBuffer>();
        StringBuffer returnString = new StringBuffer();
        returnStrings.add(returnString);
        int index0 = 0;
        int index1 = s.indexOf(reges, index0);
        while (index1 != -1) {
            returnString.append(s.substring(index0, index1) + replacement);
            index0 = index1 + reges.length();
            index1 = s.indexOf(reges, index0);
            if (returnString.length() <= 100000) continue;
            returnString = new StringBuffer();
            returnStrings.add(returnString);
        }
        returnString.append(s.substring(index0));
        returnString = new StringBuffer();
        for (int i = 0; i < returnStrings.size(); ++i) {
            returnString.append((StringBuffer)returnStrings.elementAt(i));
        }
        returnStrings.clear();
        return returnString.toString();
    }

    private static void addExpressionMarks(Node node) {
        if (node != null) {
            if (node.getNodeType() == 3) {
                node.setNodeValue("###" + node.getNodeValue() + "~~~$]]");
            }
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                WSTemplateBase.addExpressionMarks(list.item(i));
            }
        }
    }

    private static String docToExpression(Document doc) throws Exception {
        if (doc != null) {
            String template = WSTemplateBase.elementToString(doc);
            int len = template.length();
            String expression = null;
            expression = WSTemplateBase.replaceAll(template, "\"", "\"\"");
            expression = WSTemplateBase.replaceAll(expression, "<", "\"<");
            expression = WSTemplateBase.replaceAll(expression, ">", ">\"+");
            expression = WSTemplateBase.replaceAll(expression, "$]]\"", "+\"");
            expression = WSTemplateBase.replaceAll(expression, "+###", "+ _");
            expression = WSTemplateBase.replaceAll(expression, "\"\"###", "\"\"\"+ _");
            expression = WSTemplateBase.replaceAll(expression, "~~~+\"\"", " +\"\"\"");
            expression = WSTemplateBase.replaceAll(expression, "~~~", " ");
            int first = expression.indexOf("<");
            int last = expression.lastIndexOf("+");
            expression = "\"" + expression.substring(first, last);
            return expression;
        }
        return null;
    }

    public WSParam[] getParamList() {
        this.initMembers();
        WSParam[] parmListArray = null;
        if (this.m_members != null && this.m_members.length > 0) {
            Vector<WSParam> paramList = new Vector<WSParam>();
            WSParam param = null;
            for (int i = 0; i < this.m_members.length; ++i) {
                if (this.m_members[i] == null) continue;
                param = this.m_members[i].addToParamList(null);
                if (this.m_members[i].getPartName() != null && param != null) {
                    param.setPartName(this.m_members[i].getPartName());
                }
                paramList.add(param);
            }
            if (paramList != null && paramList.size() > 0) {
                parmListArray = new WSParam[paramList.size()];
                paramList.toArray(parmListArray);
                paramList.removeAllElements();
            }
        }
        return parmListArray;
    }

    static WSParam[] toFlatParamList(WSParam[] params) {
        if (params == null || params.length == 0) {
            return null;
        }
        WSParam param = null;
        Vector list = new Vector();
        Vector subList = new Vector();
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            param = params[i];
            subList = param.getFlatParamList();
            if (subList != null && subList.size() > 0) {
                list.addAll(subList);
            }
            subList.removeAllElements();
        }
        if (list != null && list.size() > 0) {
            WSParam[] paramList = new WSParam[list.size()];
            list.toArray(paramList);
            list.removeAllElements();
            return paramList;
        }
        return null;
    }

    WSParam[] getFlatParamList() {
        WSParam[] paramList = this.getParamList();
        if (paramList == null || paramList.length == 0) {
            return null;
        }
        WSParam param = null;
        Vector list = new Vector();
        Vector subList = new Vector();
        for (int i = 0; i < paramList.length; ++i) {
            if (paramList[i] == null) continue;
            param = paramList[i];
            subList = param.getFlatParamList();
            if (subList != null && subList.size() > 0) {
                list.addAll(subList);
            }
            subList.removeAllElements();
            paramList[i] = null;
        }
        paramList = null;
        param = null;
        if (list != null && list.size() > 0) {
            WSParam[] flatParamList = new WSParam[list.size()];
            list.toArray(flatParamList);
            list.removeAllElements();
            return flatParamList;
        }
        return null;
    }

    public String paramsToString() {
        WSParam[] params = this.getParamList();
        if (params != null && params.length > 0) {
            String s = new String();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                s = s + params[i].toString();
            }
            params = null;
            return s;
        }
        return null;
    }

    public void populateParameters(String expression) {
        String xml;
        this.resetParameters();
        WSParam[] parameters = this.getParamList();
        if (expression != null && parameters != null && (xml = WSTemplateBase.expressionToXML(expression)) != null) {
            Document doc = WSTemplateBase.xmlToDocument(xml);
            Node[] parts = WSParam.getPartNodes(doc);
            Object name = null;
            Object node = null;
            if (parameters != null && parameters.length > 0 && parts != null && parts.length > 0) {
                WSParam param = null;
                block0: for (int i = 0; i < parameters.length; ++i) {
                    param = parameters[i];
                    if (param == null) continue;
                    for (int j = 0; j < parts.length; ++j) {
                        if (VWStringUtils.compare(param.getName(), parts[j].getNodeName()) != 0) continue;
                        param.populate(parts[j]);
                        continue block0;
                    }
                }
            }
        }
        parameters = null;
    }

    public void removeAllParameters() {
        WSParam[] params = this.getParamList();
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                params[i].reset();
            }
        }
        params = null;
    }

    public String toString() {
        String s = new String();
        s = s + "$$$$$$$$$$$$$$$$$$$$$ Members: $$$$$$$$$$$$$$$$$$$$$$$$$\n";
        if (this.m_members != null && this.m_members.length > 0) {
            s = s + "Member count: " + this.m_members.length + "\n";
            for (int i = 0; i < this.m_members.length; ++i) {
                s = s + "member[" + i + "]" + "\n";
                s = s + this.m_members[i].toString();
            }
        } else {
            s = s + "Member count: 0\n";
        }
        return s;
    }

    public String toXML() {
        return this.toXML(0, null);
    }

    public String toXML(String[] paramOrdering) {
        return this.toXML(0, paramOrdering);
    }

    public String toXML(int bindingStyle, String[] paramOrdering) {
        String method = "toXML(int bindingStyle, paramOrdering)";
        Document doc = this.paramsToDocument(bindingStyle, paramOrdering);
        try {
            String s = WSTemplateBase.elementToString(doc);
            s = WSTemplateBase.replaceAll(s, "###", "");
            s = WSTemplateBase.replaceAll(s, "~~~$}}", "");
            return s;
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
            return null;
        }
    }

    public String toXMLExpression() {
        return this.toXMLExpression(0, null);
    }

    public String toXMLExpression(String[] paramOrdering) {
        return this.toXMLExpression(0, paramOrdering);
    }

    public String toXMLExpression(int bindingStyle, String[] paramOrdering) {
        String method = "toXMLExpression(int bindingStyle, paramOrdering)";
        Document doc = this.paramsToDocument(bindingStyle, paramOrdering);
        try {
            return WSTemplateBase.docToExpression(doc);
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
            return null;
        }
    }

    public String toXMLTemplate() {
        return this.toXMLTemplate(0, null);
    }

    public String toXMLTemplate(String[] paramOrdering) {
        return this.toXMLTemplate(0, paramOrdering);
    }

    public String toXMLTemplate(int bindingStyle, String[] paramOrdering) {
        String method = "toXMLTemplate(int bindingStyle, paramOrdering)";
        Document doc = this.paramsToTemplateDocument(bindingStyle, paramOrdering);
        try {
            String s = WSTemplateBase.elementToString(doc);
            s = WSTemplateBase.replaceAll(s, "###", "");
            s = WSTemplateBase.replaceAll(s, "~~~$]]", "");
            return s;
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
            return null;
        }
    }

    public String toXMLTemplateExpression() {
        return this.toXMLTemplateExpression(0, null);
    }

    public String toXMLTemplateExpression(String[] paramOrdering) {
        return this.toXMLTemplateExpression(0, paramOrdering);
    }

    public String toXMLTemplateExpression(int bindingStyle, String[] paramOrdering) {
        String method = "toXMLTemplateExpression(int bindingStyle, paramOrdering)";
        Document doc = this.paramsToTemplateDocument(bindingStyle, paramOrdering);
        try {
            return WSTemplateBase.docToExpression(doc);
        }
        catch (Exception ex) {
            logger.throwing(m_className, method, ex);
            return null;
        }
    }

    protected static WSParam[] orderParameters(WSParam[] params, String[] paramOrdering) {
        if (paramOrdering == null || paramOrdering.length == 0) {
            return params;
        }
        if (params != null && params.length > 0) {
            WSParam[] paramList = new WSParam[paramOrdering.length];
            Vector<WSParam> v = new Vector<WSParam>();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null || params[i].getPartName() == null) continue;
                boolean bFound = false;
                for (int j = 0; j < paramOrdering.length; ++j) {
                    if (paramOrdering[j] == null || params[i].getPartName() == null || VWStringUtils.compare(paramOrdering[j], params[i].getPartName()) != 0) continue;
                    paramList[j] = params[i];
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                v.add(params[i]);
            }
            Vector<WSParam> vector = new Vector<WSParam>();
            for (int i = 0; i < paramList.length; ++i) {
                if (paramList[i] == null) continue;
                vector.add(paramList[i]);
            }
            if (v.size() > 0) {
                vector.addAll(v);
            }
            if (vector.size() > 0) {
                paramList = new WSParam[vector.size()];
                vector.toArray(paramList);
                vector.removeAllElements();
                return paramList;
            }
        }
        return null;
    }

    protected Document paramsToTemplateDocument(int bindingStyle, String[] paramOrdering) {
        WSParam[] params = WSTemplateBase.orderParameters(this.getParamList(), paramOrdering);
        if (params != null && params.length > 0) {
            Document doc = null;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (Exception ex) {
                doc = new DocumentImpl();
            }
            Element root = null;
            String name = this.getTemplateRootName();
            root = doc.createElement(name);
            doc.appendChild(root);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                params[i].addTemplateElement(doc, root, bindingStyle);
            }
            params = null;
            return doc;
        }
        return null;
    }

    private Document paramsToDocument(int bindingStyle, String[] paramOrdering) {
        WSParam[] params = WSTemplateBase.orderParameters(this.getParamList(), paramOrdering);
        if (params != null && params.length > 0) {
            Document doc = null;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (Exception ex) {
                doc = new DocumentImpl();
            }
            Element root = null;
            String name = this.getTemplateRootName();
            root = doc.createElement(name);
            doc.appendChild(root);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                root.appendChild(params[i].createElement(doc, bindingStyle));
            }
            return doc;
        }
        return null;
    }

    private void resetParameters() {
        WSParam[] params = this.getParamList();
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                params[i].reset();
            }
            params = null;
        }
    }

    static String encodeTypeName(String typename) {
        return s_leadingTypeNameCode + typename + s_trailingTypeNameCode;
    }
}

